/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: stupid_api_checks.c,v 1.12 2006/03/31 19:34:36 karen Exp $";

/****************************************************************
 * Stupid api checks
 ****************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include "mx_auto_config.h"
#include "myriexpress.h"

char *progname;
 void 
static inline return_check( mx_return_t rc, char *str) 
{
  if (rc != MX_SUCCESS) {
    printf( "%s : %s\n", str, mx_strerror(rc));
    exit (1);
  }
}

void 
usage(void)
{ 
  printf("Usage %s [-h hostname]\n", progname);
  exit (1);
}

int
main (int argc, char *argv[])
{
  int c;
  extern char *optarg;

  mx_endpoint_t ep;
  mx_endpoint_addr_t ep_addr;
  uint64_t nic_id;
  uint32_t ep_id;
  uint32_t filter_val;

  char hostname[MX_MAX_HOSTNAME_LEN];
  char *remote_host;
  int remote_host_set = 0;

  mx_return_t rc;

  progname = argv[0];

  while ((c = getopt(argc, argv, "h:")) != EOF) switch(c) {
  case 'h':
    remote_host = optarg;
    remote_host_set = 1;
    break;
  default:
    usage();
  }

  if (!remote_host_set) usage();

  rc = mx_init();
  return_check(rc, "mx_init");

  rc = mx_hostname_to_nic_id(remote_host, &nic_id);
  return_check(rc, "mx_hostname_to_nic_id");
  printf ("Converted hostname '%s' to nic_id 0x%08x%08x\n",
	  remote_host, MX_U32(nic_id), MX_L32(nic_id));

  rc = mx_nic_id_to_hostname(nic_id, hostname);
  return_check(rc, "mx_nic_id_to_hostname");
  printf ("Converted nic_id 0x%08x%08x to hostname '%s'\n",
	  MX_U32(nic_id), MX_L32(nic_id), hostname);
 
  rc = mx_open_endpoint(MX_ANY_NIC, MX_ANY_ENDPOINT, filter_val, NULL, 0, &ep);
  return_check(rc, "mx_open_endpoint");

  ep_id = 12;
  filter_val = 0x12345678;
  rc = mx_connect(ep, nic_id, ep_id, filter_val, MX_INFINITE, &ep_addr);
  return_check(rc, "mx_compose_endpoint");
  printf("Composed an endpoint_addr for %s\n", hostname);
  printf("nic_id 0x%08x%08x, endpoint_id %d, filter_val 0x%08x\n",
	 MX_U32(nic_id), MX_L32(nic_id), ep_id, filter_val);

  nic_id = 0; ep_id = 0; filter_val = 0;
  rc = mx_decompose_endpoint_addr(ep_addr, &nic_id, &ep_id);
  printf("Decomposing the endpoint\n");
  printf("nic_id 0x%08x%08x, endpoint_id %d\n",
	 MX_U32(nic_id), MX_L32(nic_id), ep_id);
  
  rc = mx_get_endpoint_addr(ep, &ep_addr);
  return_check(rc, "mx_get_endpoint_addr");

  rc = mx_decompose_endpoint_addr( ep_addr, &nic_id, &ep_id);
  return_check(rc, "mx_decompose_endpint_addr");

  printf("Decomposing my our own endpoint gives us:\n");
  printf("nic_id 0x%08x%08x, endpoint_id %d\n",
	 MX_U32(nic_id), MX_L32(nic_id), ep_id);

  mx_finalize();
  return 0;
}



	 
